/*
    PsyTexx: modplay.h. MOD structures.
    Copyright (C) 2004  Zolotov Alexandr

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//*** Contact info: Zolotov Alexandr (NightRadio project)
//***               Ekaterinburg. Russia.
//***               Email: observer_page@mail.ru
//***                      warmplace@warmplace.ru
//***                      nightradio@knoppix.ru
//***               WWW: warmplace.ru

//extern int      modload(char * filename);
//extern int      modinit(int frequency);
//extern int      modplay(void);
//extern int      modpoll(void);
//extern int      modstop(void);

typedef unsigned char   uchar;
typedef unsigned short   uint;
typedef unsigned long   ulong;

typedef struct {
        uchar   name[22];
        uint    length;
        uchar   finetune;
        uchar   volume;
        uint    reppnt;
        uint    replen;
} sample;

typedef struct {
        uchar   sampperiod;
        uchar   period;
        uchar   sampeffect;
        uchar   effect;
} note;

typedef struct {
        uchar   title[20];
        uchar   _samples[930]; //sample  samples[31];
        uchar   length;
        uchar   protracker;
        uchar   patterntable[128];
        uchar   signature[4];
        sample  *samples[31];
} module;

#define SF_ANTICLICK   1
#define SF_SPORTAMENTO 2
#define SF_DISTORTION  4
#define SF_CUTOFF      8
#define SF_RESONANCE   16
#define SF_WAHWAH      32

typedef struct {
		long spec_effects;
		long old_volume;   //ANTICLICK    'A'
		long new_delta;    //SPORTAMENTO  'S'
		long ddelta;       //...
		long dist;         //DISTORTION   'D'
		long cutoff;       //CUTOFF       'C' ( 0 - max; 256 - min )
		long cold_volume;  //...
		long res_volume;   //RESONANCE    'R' ( 0 - max; 8 - min )
		long res_delta;    //...
		long res_ptr;      //...
		long wah_offset;   //WAHWAH       'W' ( 0 ... 256<<16 )
		long wah_add;      //...
		long wah_amp;      //...

		long pitch;        //pitch delta (0 - off)
		ulong pitch_ticks; //pitch ticks

		long anticlick;       //0 ... 255
		long anticlick_start; //start sample value
		long previous_value;

		long echo_volume;

		//long add_sounds; //number of additional tones
		//long add_period[8];
		//long add_ticks[8];

        signed char * sampdata;
        signed long   period;
        ulong   delta;
        ulong   ticks;
        signed long  new_period;

        uint    sampnum;
        uint    length;
        uint    reppnt;
        uint    replen;
        uint  rep;
        signed short   p_delta; //period delta.
        signed short   p_olddelta;
        uint  p_up;
        uint  p_down;

        uint   v_up;
		uint   v_down;
		uint   global_volume_l;
		uint   global_volume_r;
		uint   summar_volume;
		uint temp;
		signed char   volume;
} channel;
